% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 8Mar2012
% TITLE: Simple Time Estimation Model with Linear Regression (LR) in Action
% Related web page:
% http://finaquant.com/predictive-modelling-with-linear-regression/520

% Hypothetical function that describe the assumed physical relationships.
% The resultant time record (y) is a function of three parameters:
% - x1: wind speed (km/h)
% - x2: weight (kg)
% - t: temperature (Celcius); optimal running temperature is 20 C
%
% The parameter "temperature" which is not captured by the estimation model
% represents generally all kinds of unknown factors affecting the outcome.
% In that sense, this parameter also represents the uncertainty and error
% in estimations based on input parameters x2 and/or x1.

function y = run_time_record(x1, x2, t)
    y = 12 + (0.1*x1) + (0.0005* x1.^2) + (0.15*x2) + (0.003*x2.^2) + 0.005*abs(t-20).^2;
end
